/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader.jsonapi;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.JsonAPILoader;
import customskinloader.loader.MojangAPILoader;
import customskinloader.plugin.ICustomSkinLoaderPlugin;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpTextureUtil;
import java.io.File;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class MinecraftCapesAPI
implements JsonAPILoader.IJsonAPI {
    @Override
    public List<ICustomSkinLoaderPlugin.IDefaultProfile> getDefaultProfiles(JsonAPILoader loader) {
        return Lists.newArrayList((Object[])new ICustomSkinLoaderPlugin.IDefaultProfile[]{new MinecraftCapes(loader)});
    }

    @Override
    public String toJsonUrl(String root, String username) {
        String uuid = MojangAPILoader.getMojangUuidByUsername(username);
        if (uuid == null) {
            return null;
        }
        return root + uuid;
    }

    @Override
    public UserProfile toUserProfile(String root, String json, boolean local) {
        MinecraftCapesApiResponse result = (MinecraftCapesApiResponse)new Gson().fromJson(json, MinecraftCapesApiResponse.class);
        if (result.textures == null || result.textures.cape == null) {
            return null;
        }
        String capeBase64 = result.textures.cape;
        byte[] capeBytes = Base64.decodeBase64((String)capeBase64);
        String hash = HttpTextureUtil.getHash(capeBytes);
        File cacheFile = HttpTextureUtil.getCacheFile(hash);
        String fakeUrl = HttpTextureUtil.getBase64FakeUrl(hash);
        try {
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])capeBytes);
            CustomSkinLoader.logger.info("Saved base64 image to " + cacheFile);
        }
        catch (Exception e) {
            CustomSkinLoader.logger.warning("Error parsing base64 image: " + capeBase64);
            return null;
        }
        UserProfile profile = new UserProfile();
        profile.capeUrl = fakeUrl;
        return profile;
    }

    @Override
    public String getPayload(SkinSiteProfile ssp) {
        return null;
    }

    @Override
    public String getName() {
        return "MinecraftCapesAPI";
    }

    public static class MinecraftCapesApiResponse {
        public boolean animatedCape;
        public boolean capeGlint;
        public boolean upsideDown;
        public MinecraftCapesApiTexture textures;

        public static class MinecraftCapesApiTexture {
            public String cape;
            public String ears;
        }
    }

    public static class MinecraftCapes
    extends JsonAPILoader.DefaultProfile {
        public MinecraftCapes(JsonAPILoader loader) {
            super(loader);
        }

        @Override
        public String getName() {
            return "MinecraftCapes";
        }

        @Override
        public int getPriority() {
            return 800;
        }

        @Override
        public String getRoot() {
            return "https://minecraftcapes.net/profile/";
        }
    }
}

